/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.roadstuff.data.gen;

import java.util.Arrays;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import tv.mapper.mapperbase.data.gen.BaseBlockStates;
import tv.mapper.roadstuff.world.level.block.PaintBucketBlock;
import tv.mapper.roadstuff.world.level.block.PaintSystem;
import tv.mapper.roadstuff.world.level.block.RSBlockRegistry;
import tv.mapper.roadstuff.world.level.block.RotatableSlopeBlock;
import tv.mapper.roadstuff.world.level.block.state.properties.EnumPaintColor;

public class RSBlockStates
extends BaseBlockStates {
    public RSBlockStates(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)RSBlockRegistry.CONCRETE.get());
        this.slopeBlock((Block)RSBlockRegistry.CONCRETE_SLOPE.get(), "concrete", "roadstuff");
        this.slabBlock((SlabBlock)RSBlockRegistry.CONCRETE_SLAB.get(), this.modLoc("block/concrete"), this.modLoc("block/concrete"), this.modLoc("block/concrete"), this.modLoc("block/concrete"));
        this.stairsBlock((StairBlock)RSBlockRegistry.CONCRETE_STAIRS.get(), this.modLoc("block/concrete"), this.modLoc("block/concrete"), this.modLoc("block/concrete"));
        this.newWallBlock((WallBlock)RSBlockRegistry.CONCRETE_WALL.get(), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/concrete_wall_post"), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/concrete_wall_side"), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/concrete_wall_side_tall"));
        this.pressurePlateBlock((PressurePlateBlock)RSBlockRegistry.CONCRETE_PRESSURE_PLATE.get(), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/concrete_pressure_plate"), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/concrete_pressure_plate_down"));
        this.fenceBlock((FenceBlock)RSBlockRegistry.CONCRETE_FENCE.get(), this.modLoc("block/concrete"));
        this.fenceGateBlock((FenceGateBlock)RSBlockRegistry.CONCRETE_FENCE_GATE.get(), this.modLoc("block/concrete"));
        this.simpleBlock((Block)RSBlockRegistry.ASPHALT.get());
        this.slopeBlock((Block)RSBlockRegistry.ASPHALT_SLOPE.get(), "asphalt", "roadstuff");
        this.slabBlock((SlabBlock)RSBlockRegistry.ASPHALT_SLAB.get(), this.modLoc("block/asphalt"), this.modLoc("block/asphalt"), this.modLoc("block/asphalt"), this.modLoc("block/asphalt"));
        this.stairsBlock((StairBlock)RSBlockRegistry.ASPHALT_STAIRS.get(), this.modLoc("block/asphalt"), this.modLoc("block/asphalt"), this.modLoc("block/asphalt"));
        this.pressurePlateBlock((PressurePlateBlock)RSBlockRegistry.ASPHALT_PRESSURE_PLATE.get(), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/asphalt_pressure_plate"), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/asphalt_pressure_plate_down"));
        for (RegistryObject<Block> block : RSBlockRegistry.MOD_PAINTABLEBLOCKS) {
            if (!(block.get() instanceof PaintSystem)) continue;
            String[] raw = ((Block)block.get()).m_7705_().split("_");
            String mat = raw[0].contains("asphalt") ? "asphalt" : "concrete";
            String number = raw[1].equals("slope") ? raw[4] : raw[3];
            if (block.get() instanceof RotatableSlopeBlock) {
                this.rotatableSlopeBlock((Block)block.get(), mat, number, 180);
                continue;
            }
            this.horizontalBlock((Block)block.get(), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/" + mat + "_line_" + number), 180);
        }
        this.simpleBlock((Block)RSBlockRegistry.BITUMEN_ORE.get());
        this.simpleBlock((Block)RSBlockRegistry.BITUMEN_BLOCK.get());
        int i = 0;
        while ((long)i < Arrays.stream(DyeColor.values()).count()) {
            this.simpleBlock((Block)RSBlockRegistry.TRAFFIC_CONE_BLOCKS.get(DyeColor.m_41053_((int)i)).get(), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/" + DyeColor.m_41053_((int)i).m_7912_() + "_traffic_cone"));
            this.simpleBlock((Block)RSBlockRegistry.TRAFFIC_BARREL_BLOCKS.get(DyeColor.m_41053_((int)i)).get(), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/" + DyeColor.m_41053_((int)i).m_7912_() + "_traffic_barrel"));
            this.simpleBlock((Block)RSBlockRegistry.TRAFFIC_BOLLARD_BLOCKS.get(DyeColor.m_41053_((int)i)).get(), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/" + DyeColor.m_41053_((int)i).m_7912_() + "_traffic_bollard"));
            this.simpleBlock((Block)RSBlockRegistry.CYLINDRICAL_BOLLARD_BLOCKS.get(DyeColor.m_41053_((int)i)).get(), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/" + DyeColor.m_41053_((int)i).m_7912_() + "_cylindrical_bollard"));
            this.horizontalBlock((Block)RSBlockRegistry.REFLECTOR_BLOCKS.get(DyeColor.m_41053_((int)i)).get(), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/" + DyeColor.m_41053_((int)i).m_7912_() + "_reflector"), 0);
            this.horizontalBlock((Block)RSBlockRegistry.LUMINESCENT_REFLECTOR_BLOCKS.get(DyeColor.m_41053_((int)i)).get(), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/" + DyeColor.m_41053_((int)i).m_7912_() + "_reflector"), 0);
            this.guardrailBlock((CrossCollisionBlock)RSBlockRegistry.GUARDRAIL_BLOCKS.get(DyeColor.m_41053_((int)i)).get(), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/" + DyeColor.m_41053_((int)i).m_7912_() + "_guardrail_post"), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/" + DyeColor.m_41053_((int)i).m_7912_() + "_guardrail_side"));
            ++i;
        }
        this.guardrailBlock((CrossCollisionBlock)RSBlockRegistry.STEEL_GUARDRAIL.get(), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/steel_guardrail_post"), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/steel_guardrail_side"));
        this.horizontalBlock((Block)RSBlockRegistry.YELLOW_BOLLARD.get(), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/yellow_bollard"), 180);
        this.horizontalBlock((Block)RSBlockRegistry.WHITE_BOLLARD.get(), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/white_bollard"), 180);
        this.horizontalBlock((Block)RSBlockRegistry.RED_BOLLARD.get(), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/red_bollard"), 180);
        this.horizontalBlock((Block)RSBlockRegistry.YELLOW_SMALL_BOLLARD.get(), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/yellow_small_bollard"), 180);
        this.horizontalBlock((Block)RSBlockRegistry.WHITE_SMALL_BOLLARD.get(), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/white_small_bollard"), 180);
        this.horizontalBlock((Block)RSBlockRegistry.RED_SMALL_BOLLARD.get(), (ModelFile)new ModelFile.UncheckedModelFile("roadstuff:block/red_small_bollard"), 180);
        this.paintBucketBlock((Block)RSBlockRegistry.PAINT_BUCKET.get(), 0);
    }

    protected void rotatableSlopeBlock(Block block, String name, String pattern, int offset) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        Object modelName = "";
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            for (int i = 1; i < 9; ++i) {
                modelName = i == 8 ? "roadstuff:block/" + name + "_line_" + pattern : "roadstuff:block/" + name + "_slope_" + i * 2 + "_line_" + pattern;
                builder.partialState().with((Property)RotatableSlopeBlock.DIRECTION, (Comparable)dir).with((Property)RotatableSlopeBlock.LAYERS, (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)new ModelFile.UncheckedModelFile((String)modelName)).rotationY((int)((dir.m_122435_() + (float)offset) % 360.0f)).addModel();
            }
        }
    }

    protected void paintBucketBlock(Block block, int offset) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        Object modelName = "";
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            for (int i = 0; i < 9; ++i) {
                modelName = i == 0 ? "roadstuff:block/paint_bucket" : "roadstuff:block/paint_bucket_white_" + i;
                builder.partialState().with(PaintBucketBlock.COLOR, (Comparable)((Object)EnumPaintColor.WHITE)).with((Property)PaintBucketBlock.DIRECTION, (Comparable)dir).with((Property)PaintBucketBlock.PAINT, (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)new ModelFile.UncheckedModelFile((String)modelName)).rotationY((int)((dir.m_122435_() + (float)offset) % 360.0f)).addModel();
                modelName = i == 0 ? "roadstuff:block/paint_bucket" : "roadstuff:block/paint_bucket_yellow_" + i;
                builder.partialState().with(PaintBucketBlock.COLOR, (Comparable)((Object)EnumPaintColor.YELLOW)).with((Property)PaintBucketBlock.DIRECTION, (Comparable)dir).with((Property)PaintBucketBlock.PAINT, (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)new ModelFile.UncheckedModelFile((String)modelName)).rotationY((int)((dir.m_122435_() + (float)offset) % 360.0f)).addModel();
            }
        }
    }

    public void guardrailBlock(CrossCollisionBlock block, ModelFile post, ModelFile side) {
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block).part().modelFile(post).addModel()).end();
        this.guardrailBlock(builder, side);
    }

    public void guardrailBlock(MultiPartBlockStateBuilder builder, ModelFile side) {
        PipeBlock.f_55154_.entrySet().forEach(e -> {
            Direction dir = (Direction)e.getKey();
            if (dir.m_122434_().m_122479_()) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side).rotationY(((int)dir.m_122435_() + 180) % 360).addModel()).condition((Property)e.getValue(), (Comparable[])new Boolean[]{true});
            }
        });
    }
}

